/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveCitizenMessage
implements IMessage {
    private int colonyId;
    private int citizenId;

    public ColonyViewRemoveCitizenMessage() {
    }

    public ColonyViewRemoveCitizenMessage(@NotNull Colony colony, int citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            IColonyManager.getInstance().handleColonyViewRemoveCitizenMessage(this.colonyId, this.citizenId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        }
    }
}

